
!"Pocket Smalltalk fileout - 22:58:31, 16. bezna 2000"!


GenInteraction subclass: #GenInteractionSmalltalk
	instanceVariableNames: 'semaphore'
	classVariableNames: 'GenInteractionSmalltalkClass'!

!GenInteractionSmalltalk methodsFor: 'accessing'!

semaphore
	^semaphore!

semaphore: value
	semaphore := value! !


!GenInteractionSmalltalk methodsFor: 'Geos messages'!

gupInteractionCommand: command
	command = ##IC_DISMISS ifTrue: [
		semaphore ifNotNil: [
			Geos ThreadVSem: semaphore
		]
	].! !


!GenInteractionSmalltalk methodsFor: 'Smalltalk helper methods'!

runDialog

	semaphore := Geos ThreadAllocSem: 1.
	Geos ThreadPSem: semaphore.
	self interactionInitiate.
	Geos ThreadPSem: semaphore.
	Geos ThreadVSem: semaphore.
	Geos ThreadFreeSem: semaphore.
	semaphore := nil.! !


!GenInteractionSmalltalk class methodsFor: 'accessing'!

isInSmalltalk
	^true!

classPtr
	^GenInteractionSmalltalkClass!

initialize
	GenInteractionSmalltalkClass := self initializeSubclassHandling: (Array with: ##gupInteractionCommand -> #gupInteractionCommand:)!

instanceSize
	^self superInstanceSizePlus2! !


!GeosMetaObject class methodsFor: 'accessing'!

instanceSize
	| cs |
	cs := GCSClassStruct forPointer: self classPtr.
	^cs Class_instanceSize.! !


!GeosMetaObject class methodsFor: 'Geos class in Smalltalk'!

isInSmalltalk
	^false! !


!GeosMetaObject class methodsFor: 'Geos class in Smalltalk'!

handlerForSmalltalkMethods
	"returns the pointer as Smalltalk integer to the C language handler for Geos methods in Smalltalk"
	<primitive: 102>
	^self primitiveFailed! !


!GeosMetaObject class methodsFor: 'Geos class in Smalltalk'!

initializeSubclassHandling: messagesAssociation
	| ptr methodCount cs |
	
	methodCount := messagesAssociation size.

	"Allocate a pointer to the ClassStruct, method table, C par def. and Smalltalk selectors
	  there are 2+4+3+2=11 bytes for each message besides the basic ClassStruct"
	ptr := CPointer memPtrNew: (GCSClassStruct sizeInBytes) + methodCount*11.
	
	"populate the basic ClassStruct structure"
	(cs := GCSClassStruct forPointer: ptr)
		Class_superClass: (self superclass classPtr asInteger);
		Class_masterOffset: self level;
		Class_methodCount: methodCount;
		Class_instanceSize: self instanceSize;
		Class_vdRelocTable: 0;
		Class_relocTable: 0;
		Class_flags: 2;
		Class_masterMessages: 255. "this is a bit field, we lie that we support all master levels"
	
	"populate the method table (Geos message numbers)"
	ptr := ptr offsetBy: GCSClassStruct sizeInBytes.
	messagesAssociation do: [ :message |
		ptr wordAt: 0 put: message key.
		ptr := ptr offsetBy: 2.
	].
	
	"populate the handler addresses (Geos routine) for all messages"
	messagesAssociation do: [ :message |
		ptr dwordAt: 0 put: self handlerForSmalltalkMethods.
		ptr := ptr offsetBy: 4.
	].
	
	"populate the C parameter definitions (will disappear)"
	messagesAssociation do: [ :message |
		ptr
			wordAt: 0 put: 16r3F5;
			byteAt: 2 put: 0.
		ptr := ptr offsetBy: 3.
	].
	
	"populate the Smalltalk selectors. Selectors are smallInts and we store their value, not OOP"
	messagesAssociation do: [ :message |
		ptr wordAt: 0 put: message value.
		ptr := ptr offsetBy: 2.
	].
			
	"cs now points to a valid ClassStruct including the extended items"
	^cs pointer! !


!GeosMetaObject class methodsFor: 'utility'!

newObjBlock
	ObjBlock := self allocObjBlock.
	PstPrimary := GenPrimary basicNew.
	PstPrimary optr: Geos pstPrimary.
	^ObjBlock! !


!GeosMetaObject methodsFor: 'utility'!

addFirstUsable: child
	self addChild: child optr with: ##CCO_FIRST.
	child setUsable: ##VUM_NOW.
! !


!Gen methodsFor: 'Smalltalk helper methods'!

visMonikerWithText: text
	"create a new visMoniker of type visMonikerWithText from a Smalltalk string. The visMoniker is in the object block of the receiver (a Gen object)"

	| ptr |
	ptr := text copyToHeap.
	self giVisMoniker: (self createVisMoniker: 0 with: 0 with: 0 with: 0 with: ##VMDT_TEXT with: ##VMST_FPTR with: ptr asInteger).
	ptr free.! !


!ComplexMoniker class methodsFor: 'Smalltalk helper methods'!

triggerSlot: slot text: text dialog: dialog
	"Create a new ComplexMoniker with GenTrigger variant subclass and configure it with supplied values"
	
	^self new
		complexMoniker: GenTrigger; setVariant;
		cmiTopText: text;
		triggerSetActionMsg: ##interactionInitiate;
		triggerSetDestination: dialog optr;
		hintSeekReplyBar;
		hintSeekMenuBar;
		hintSeekSlot: slot.! !


!ComplexMoniker class methodsFor: 'Smalltalk helper methods'!

triggerSlot: slot text: text command: command
	"Create a new ComplexMoniker with GenTrigger variant subclass and configure it with supplied values"
	
	^self new
		complexMoniker: GenTrigger; setVariant;
		cmiTopText: text;
		hintSeekReplyBar;
		hintSeekMenuBar;
		hintSeekSlot: slot;
		attrGenTriggerInteractionCommand: command.

! !


!GeosMetaObject methodsFor: 'utility'!

addUsable: child
	self addChild: child optr with: ##CCO_LAST.
	child setUsable: ##VUM_NOW.
! !


!ComplexMoniker class methodsFor: 'Smalltalk helper methods'!

itemId: id text: text

	^ self new
		complexMoniker: GenItem; setVariant; initNextLevel;
		cmiTopText: (text copyToLMem: ObjBlock);
		cmiFontSize: ##FOAM_NORMAL_FONT_SIZE;
		giiIdentifier: id
! !


